/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import noppes.npcs.CustomRegisters;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.util.IPermission;
import noppes.npcs.util.Util;

public class CustomItem
extends Item
implements IPermission,
ICustomElement {
    protected NBTTagCompound nbtData;
    protected int enchantability = 10;
    protected ItemStack repairItemStack = ItemStack.field_190927_a;
    protected Item.ToolMaterial toolMaterial;
    protected Material collectionMaterial = null;
    protected float speedCollectionMaterial = 1.0f;
    protected float efficiency = 1.0f;
    protected Set<Block> effectiveBlocks = new HashSet<Block>();
    protected double attackDamage = 0.0;
    protected double attackSpeed = -2.4;

    public static Material getMaterial(String materialName) {
        switch (materialName.toLowerCase()) {
            case "air": {
                return Material.field_151579_a;
            }
            case "grass": {
                return Material.field_151577_b;
            }
            case "ground": {
                return Material.field_151578_c;
            }
            case "wood": {
                return Material.field_151575_d;
            }
            case "iron": {
                return Material.field_151573_f;
            }
            case "anvil": {
                return Material.field_151574_g;
            }
            case "water": {
                return Material.field_151586_h;
            }
            case "lava": {
                return Material.field_151587_i;
            }
            case "leaves": {
                return Material.field_151584_j;
            }
            case "plants": {
                return Material.field_151585_k;
            }
            case "vine": {
                return Material.field_151582_l;
            }
            case "sponge": {
                return Material.field_151583_m;
            }
            case "cloth": {
                return Material.field_151580_n;
            }
            case "fire": {
                return Material.field_151581_o;
            }
            case "sand": {
                return Material.field_151595_p;
            }
            case "circuits": {
                return Material.field_151594_q;
            }
            case "carpet": {
                return Material.field_151593_r;
            }
            case "glass": {
                return Material.field_151592_s;
            }
            case "redstone_light": {
                return Material.field_151591_t;
            }
            case "tnt": {
                return Material.field_151590_u;
            }
            case "coral": {
                return Material.field_151589_v;
            }
            case "ice": {
                return Material.field_151588_w;
            }
            case "packed_ice": {
                return Material.field_151598_x;
            }
            case "snow": {
                return Material.field_151597_y;
            }
            case "crafted_snow": {
                return Material.field_151596_z;
            }
            case "cactus": {
                return Material.field_151570_A;
            }
            case "clay": {
                return Material.field_151571_B;
            }
            case "gourd": {
                return Material.field_151572_C;
            }
            case "dragon_egg": {
                return Material.field_151566_D;
            }
            case "portal": {
                return Material.field_151567_E;
            }
            case "cake": {
                return Material.field_151568_F;
            }
            case "web": {
                return Material.field_151569_G;
            }
            case "piston": {
                return Material.field_76233_E;
            }
            case "barrier": {
                return Material.field_175972_I;
            }
            case "structure_void": {
                return Material.field_189963_J;
            }
        }
        return Material.field_151576_e;
    }

    public static Item.ToolMaterial getMaterialTool(NBTTagCompound nbtItem) {
        String materialName;
        switch (materialName = nbtItem.func_150297_b("Material", 8) ? nbtItem.func_74779_i("Material").toLowerCase() : "stone") {
            case "wood": {
                return Item.ToolMaterial.WOOD;
            }
            case "iron": {
                return Item.ToolMaterial.IRON;
            }
            case "diamond": {
                return Item.ToolMaterial.DIAMOND;
            }
            case "gold": {
                return Item.ToolMaterial.GOLD;
            }
        }
        return Item.ToolMaterial.STONE;
    }

    public CustomItem(NBTTagCompound nbtItem) {
        this.nbtData = nbtItem;
        this.setRegistryName("customnpcs", "custom_" + nbtItem.func_74779_i("RegistryName"));
        this.func_77655_b("custom_" + nbtItem.func_74779_i("RegistryName"));
        int n = this.field_77777_bU = nbtItem.func_150297_b("MaxStackSize", 3) ? nbtItem.func_74762_e("MaxStackSize") : 64;
        if (this.field_77777_bU > 64) {
            this.field_77777_bU = 64;
        }
        if (nbtItem.func_150297_b("SpeedAttack", 6)) {
            this.attackSpeed = nbtItem.func_74769_h("SpeedAttack");
        }
        if (nbtItem.func_150297_b("EntityDamage", 6)) {
            this.attackDamage = nbtItem.func_74769_h("EntityDamage");
        }
        if (nbtItem.func_150297_b("Efficiency", 5)) {
            this.efficiency = nbtItem.func_74760_g("Efficiency");
        }
        if (nbtItem.func_150297_b("IsFull3D", 1) && nbtItem.func_74767_n("IsFull3D")) {
            this.func_77664_n();
        }
        if (nbtItem.func_74762_e("MaxStackDamage") > 1) {
            this.func_77656_e(nbtItem.func_74762_e("MaxStackDamage"));
        }
        if (nbtItem.func_150297_b("CollectionMaterial", 10)) {
            this.collectionMaterial = CustomItem.getMaterial(nbtItem.func_74775_l("collectionMaterial").func_74779_i("Material"));
            this.speedCollectionMaterial = nbtItem.func_74775_l("collectionMaterial").func_74760_g("Speed");
        }
        if (nbtItem.func_150297_b("Enchantability", 3)) {
            this.enchantability = nbtItem.func_74762_e("Enchantability");
        }
        if (nbtItem.func_150297_b("RepairItem", 10)) {
            this.repairItemStack = new ItemStack(nbtItem.func_74775_l("RepairItem"));
        }
        this.toolMaterial = CustomItem.getMaterialTool(nbtItem);
        if (nbtItem.func_150297_b("CollectionBlocks", 9)) {
            for (int j = 0; j < nbtItem.func_150295_c("CollectionBlocks", 8).func_74745_c(); ++j) {
                Block block = Block.func_149684_b((String)nbtItem.func_150295_c("CollectionBlocks", 8).func_150307_f(j));
                if (block == null) continue;
                this.effectiveBlocks.add(block);
            }
        }
        this.func_77637_a(CustomRegisters.tabItems);
        this.func_77627_a(true);
    }

    @Override
    public String getCustomName() {
        return this.nbtData.func_74779_i("RegistryName");
    }

    @Override
    public INbt getCustomNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.nbtData);
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull IBlockState state) {
        if (state.func_185904_a() == this.collectionMaterial) {
            return this.speedCollectionMaterial;
        }
        if (this.effectiveBlocks.contains(state.func_177230_c())) {
            for (String type : this.getToolClasses(stack)) {
                if (!state.func_177230_c().isToolEffective(type, state)) continue;
                return this.efficiency;
            }
            return this.efficiency;
        }
        if (state.func_177230_c() == Blocks.field_150321_G) {
            return 15.0f;
        }
        return 1.0f;
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        if (this.nbtData != null && this.nbtData.func_150297_b("DurabilityValue", 6)) {
            return 1.0 - this.nbtData.func_74769_h("DurabilityValue");
        }
        return super.getDurabilityForDisplay(stack);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (tab != CustomRegisters.tabItems && tab != CreativeTabs.field_78027_g) {
            return;
        }
        if (this.nbtData != null && this.nbtData.func_150297_b("ShowInCreative", 1) && !this.nbtData.func_74767_n("ShowInCreative")) {
            return;
        }
        items.add((Object)new ItemStack((Item)this));
        if (tab == CustomRegisters.tabItems) {
            Util.instance.sort(items);
        }
    }

    @Override
    public boolean isAllowed(EnumPacketServer enumPacket) {
        return true;
    }

    @Override
    public int getType() {
        if (this.nbtData != null && this.nbtData.func_150297_b("ItemType", 1)) {
            return this.nbtData.func_74771_c("ItemType");
        }
        return 9;
    }
}

